/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.client.PIIOSlotDataBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscBaseException;
import com.ibm.hsc.common.util.ErrorPanel;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscUtilBase;
import com.ibm.hsc.common.util.Trace;
import com.ibm.jcb.RemoteSourceException;
import com.ibm.ui.framework.TaskMessage;
import com.ibm.ui.framework.UserTaskManager;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.StringTokenizer;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt64;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMClient;

public class PIHscUtil
extends HscUtilBase {
    public static CIMObjectPath constructPath(CIMInstance cIMInstance) {
        return PIHscUtil.constructPath(cIMInstance, "root/ibmhscS1_0");
    }

    public static CIMClient openCIMClient(String string) {
        return PIHscUtil.openCIMClient(string, "root/ibmhscS1_0");
    }

    public static void subscribeForCIMEvent(String string) {
        PIHscUtil.subscribeForCIMEvent(string, "root/ibmhscS1_0");
    }

    public static boolean isCorrectNameLength(String string, int n) throws CIMException {
        byte[] byArray = null;
        try {
            byArray = string.trim().getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            Trace.trace("appphscF", "Unsupported encoding exception - US-ASCII");
            throw new HSCCIMException("The user defined name is not ASCII-encoded.");
        }
        int n2 = byArray.length;
        return n2 <= n;
    }

    public static boolean nameHasCorrectCharacters(String string) throws CIMException {
        byte[] byArray = null;
        try {
            byArray = string.trim().getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            Trace.trace("appphscF", "Unsupported encoding exception - US-ASCII");
            throw new HSCCIMException("The user defined name is not ASCII-encoded.");
        }
        int n = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            if (!Character.isISOControl((char)byArray[i]) && (char)byArray[i] <= '~') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidTime(String string, String string2) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            if (stringTokenizer.countTokens() != 6) {
                return false;
            }
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            int n5 = Integer.parseInt(stringTokenizer.nextToken());
            int n6 = Integer.parseInt(stringTokenizer.nextToken());
            if (n6 > 59 || n5 > 59 || n4 > 23 || n > 12) {
                return false;
            }
            if (n6 < 0 || n5 < 0 || n4 < 0 || n < 0 || n3 < 0 || n2 < 0) {
                return false;
            }
            switch (n) {
                case 1: {
                    if (n2 > 31) {
                        return false;
                    }
                }
                case 2: {
                    if (n2 > 29) {
                        return false;
                    }
                }
                case 3: {
                    if (n2 > 31) {
                        return false;
                    }
                }
                case 4: {
                    if (n2 > 30) {
                        return false;
                    }
                }
                case 5: {
                    if (n2 > 31) {
                        return false;
                    }
                }
                case 6: {
                    if (n2 > 30) {
                        return false;
                    }
                }
                case 7: {
                    if (n2 > 31) {
                        return false;
                    }
                }
                case 8: {
                    if (n2 > 31) {
                        return false;
                    }
                }
                case 9: {
                    if (n2 > 30) {
                        return false;
                    }
                }
                case 10: {
                    if (n2 > 31) {
                        return false;
                    }
                }
                case 11: {
                    if (n2 > 30) {
                        return false;
                    }
                }
                case 12: {
                    if (n2 <= 31) break;
                    return false;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static long[] convertToLongArray(UnsignedInt32[] unsignedInt32Array) {
        long l = 0L;
        long[] lArray = new long[unsignedInt32Array.length];
        for (int i = 0; i < unsignedInt32Array.length; ++i) {
            lArray[i] = l = unsignedInt32Array[i].longValue();
        }
        return lArray;
    }

    public static long[] convertToLongArray(UnsignedInt64[] unsignedInt64Array) {
        long l = 0L;
        long[] lArray = new long[unsignedInt64Array.length];
        for (int i = 0; i < unsignedInt64Array.length; ++i) {
            lArray[i] = l = unsignedInt64Array[i].longValue();
        }
        return lArray;
    }

    public static long[] convertToLongArray(Long[] longArray) {
        long l = 0L;
        long[] lArray = new long[longArray.length];
        for (int i = 0; i < longArray.length; ++i) {
            lArray[i] = l = longArray[i].longValue();
        }
        return lArray;
    }

    public static int[] convertToIntArray(UnsignedInt8[] unsignedInt8Array) {
        int n = 0;
        int[] nArray = new int[unsignedInt8Array.length];
        for (int i = 0; i < unsignedInt8Array.length; ++i) {
            nArray[i] = n = unsignedInt8Array[i].intValue();
        }
        return nArray;
    }

    public static int[] convertToIntArray(UnsignedInt16[] unsignedInt16Array) {
        int n = 0;
        int[] nArray = new int[unsignedInt16Array.length];
        for (int i = 0; i < unsignedInt16Array.length; ++i) {
            nArray[i] = n = unsignedInt16Array[i].intValue();
        }
        return nArray;
    }

    public static int[] convertToIntArray(Integer[] integerArray) {
        int n = 0;
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = n = integerArray[i].intValue();
        }
        return nArray;
    }

    public static int[] convertToIntArray(Short[] shortArray) {
        int n = 0;
        int[] nArray = new int[shortArray.length];
        for (int i = 0; i < shortArray.length; ++i) {
            nArray[i] = n = shortArray[i].intValue();
        }
        return nArray;
    }

    public static Vector uint16VecToIntVec(Vector vector) {
        Vector<Integer> vector2 = new Vector<Integer>();
        for (int i = 0; i < vector.size(); ++i) {
            int n = ((UnsignedInt16)vector.elementAt(i)).intValue();
            Integer n2 = new Integer(n);
            vector2.addElement(n2);
        }
        return vector2;
    }

    public static Vector uint8VecToIntVec(Vector vector) {
        Vector<Integer> vector2 = new Vector<Integer>();
        for (int i = 0; i < vector.size(); ++i) {
            int n = ((UnsignedInt8)vector.elementAt(i)).intValue();
            Integer n2 = new Integer(n);
            vector2.addElement(n2);
        }
        return vector2;
    }

    public static ArrayList arrayToList(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(objectArray[i]);
            }
        }
        if (arrayList.isEmpty()) {
            arrayList = null;
        }
        return arrayList;
    }

    public static String getLparStateString(UnsignedInt8 unsignedInt8) {
        String string;
        if (unsignedInt8 == null) {
            string = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "LPAR_STATE_UNAVAILABLE");
        } else {
            switch (unsignedInt8.intValue()) {
                case 0: {
                    string = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "LPAR_STATE_NOT_ACTIVATED");
                    break;
                }
                case 1: {
                    string = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "LPAR_STATE_STARTING");
                    break;
                }
                case 2: {
                    string = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "LPAR_STATE_RUNNING");
                    break;
                }
                case 3: {
                    string = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "LPAR_STATE_SHUTDOWN");
                    break;
                }
                case 4: {
                    string = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "ERROR");
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    string = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "ERROR");
                    break;
                }
                case 8: {
                    string = HSCResourceBundleUtil.getMessage("LPARBundle", "LPAR_STATE_OPEN_FIRMWARE");
                    break;
                }
                case 252: {
                    string = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "LPAR_STATE_UNAVAILABLE");
                    break;
                }
                default: {
                    string = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "LPAR_STATE_UNAVAILABLE");
                }
            }
        }
        return string;
    }

    public static String getStringMsgIdFromShortMsgId(short s) {
        short s2 = (short)(s & 0xFFFF);
        int n = 4;
        while ((s2 & 0xF) != 0) {
            s2 = (short)(s2 >> 4);
            --n;
        }
        String string = "";
        while (n != 0) {
            string = string + "0";
            --n;
        }
        int n2 = 16;
        string = string + Integer.toString(s, n2);
        return string;
    }

    public static boolean isStorageBrand(UnsignedInt16 unsignedInt16) {
        int n;
        return unsignedInt16 != null && (n = unsignedInt16.intValue() >> 8) == 68;
    }

    public static boolean isISeriesBrand(UnsignedInt16 unsignedInt16) {
        int n;
        return unsignedInt16 != null && ((n = unsignedInt16.intValue() >> 8) == 73 || n == 78);
    }

    public static boolean isPSeriesBrand(UnsignedInt16 unsignedInt16) {
        int n;
        return unsignedInt16 != null && ((n = unsignedInt16.intValue() >> 8) == 80 || n == 79);
    }

    public static Vector returnSuppVirPanelFuncsVec(BitSet bitSet) {
        Vector<Integer> vector = new Vector<Integer>();
        if (bitSet == null || bitSet.length() == 0) {
            return vector;
        }
        for (int i = 0; i < bitSet.length(); ++i) {
            boolean bl = bitSet.get(i);
            if (!bl) continue;
            vector.add(new Integer(i + 1));
        }
        System.out.println("PIVirtualPanelFunctions: return supported vector:" + vector);
        return vector;
    }

    public static String convertFirmwareVersionTokenToString(Number number, Number number2, Number number3, Number number4, Number number5, Number number6) {
        int n = number == null ? 0 : number.intValue();
        int n2 = number2 == null ? 0 : number2.intValue();
        int n3 = number3 == null ? 0 : number3.intValue();
        int n4 = number4 == null ? 0 : number4.intValue();
        int n5 = number5 == null ? 0 : number5.intValue();
        int n6 = number6 == null ? 0 : number6.intValue();
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 32769: {
                stringBuffer.append("AIX ");
                stringBuffer.append(n2).append('.');
                stringBuffer.append(n3).append('.');
                stringBuffer.append(n4);
                stringBuffer.append(" ").append(n5);
                stringBuffer.append(" ").append(n6);
                break;
            }
            case 32770: {
                stringBuffer.append("Linux ");
                stringBuffer.append(n2).append('.');
                stringBuffer.append(n3).append('.');
                stringBuffer.append(n4);
                stringBuffer.append(" ").append(n5);
                stringBuffer.append(" ").append(n6);
                break;
            }
            case 32771: {
                stringBuffer.append("OS/400 ");
                stringBuffer.append("V").append(n2);
                stringBuffer.append("R").append(n3);
                stringBuffer.append("M").append(n4);
                stringBuffer.append(" ").append(n5);
                stringBuffer.append(" ").append(n6);
                break;
            }
            default: {
                stringBuffer.append(Integer.toHexString(n)).append(".");
                stringBuffer.append(Integer.toHexString(n2)).append(".");
                stringBuffer.append(Integer.toHexString(n3)).append(".");
                stringBuffer.append(Integer.toHexString(n4)).append(".");
                stringBuffer.append(Integer.toHexString(n5)).append(".");
                stringBuffer.append(Integer.toHexString(n6));
            }
        }
        return stringBuffer.toString();
    }

    public static void displayErrorDialog(Throwable throwable, String string, String string2, String string3, Object[] objectArray) {
        try {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._LPARClassLogInfo);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        String string4 = null;
        if (throwable instanceof RemoteSourceException) {
            Throwable throwable3 = ((RemoteSourceException)throwable).getSourceException();
            if (throwable3 instanceof PIHscBaseException) {
                string4 = throwable3.getMessage();
            }
        } else {
            string4 = HSCResourceBundleUtil.getMessage(string2, string, null, objectArray);
        }
        new ErrorPanel(string4, string3).show();
    }

    public static void handleExcep(UserTaskManager userTaskManager, Throwable throwable, String string, String string2, String string3, String string4) {
        PIHscUtil.handleExcep(userTaskManager, throwable, string2, string3, string4, (Object[])null);
    }

    public static void handleExcep(UserTaskManager userTaskManager, Throwable throwable, String string, String string2, String string3, Object[] objectArray) {
        try {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._LPARClassLogInfo);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        TaskMessage taskMessage = null;
        if (throwable instanceof RemoteSourceException) {
            Throwable throwable3 = ((RemoteSourceException)throwable).getSourceException();
            if (throwable3 instanceof PIHscBaseException) {
                taskMessage = new TaskMessage(userTaskManager, throwable3.getMessage(), string3, 1, null, null);
                taskMessage.invoke();
            } else {
                PIHscUtil.sendGenericMsg(userTaskManager, throwable, string, string2, string3, objectArray);
            }
        } else {
            PIHscUtil.sendGenericMsg(userTaskManager, throwable, string, string2, string3, objectArray);
        }
    }

    public static void sendGenericMsg(UserTaskManager userTaskManager, Throwable throwable, String string, String string2, String string3, Object[] objectArray) {
        TaskMessage taskMessage = null;
        Object var7_7 = null;
        taskMessage = string2 == null || string == null ? new TaskMessage(userTaskManager, throwable.getMessage(), string3, 1, null, null) : new TaskMessage(userTaskManager, HSCResourceBundleUtil.getMessage(string, string2, null, objectArray), string3, 1, null, null);
        taskMessage.invoke();
    }

    public static String getCecOpPanelValue(CIMInstance cIMInstance) {
        CIMValue cIMValue = cIMInstance.getProperty("OpPanelValue").getValue();
        if (cIMValue == null) {
            return null;
        }
        String string = (String)cIMValue.getValue();
        if (string == null || string.length() < 5) {
            return null;
        }
        CIMValue cIMValue2 = cIMInstance.getProperty("State").getValue();
        if (cIMValue2 == null) {
            return string;
        }
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMValue2.getValue();
        if (unsignedInt8 == null) {
            return string;
        }
        return PIHscUtil.getCecOpPanelValue(string, unsignedInt8);
    }

    public static String getCecOpPanelValue(String string, UnsignedInt8 unsignedInt8) {
        if (unsignedInt8.intValue() != 254 && unsignedInt8.intValue() != 250 && unsignedInt8.intValue() != 241 && unsignedInt8.intValue() != 242) {
            return string;
        }
        if (string.indexOf("-") != 4) {
            return string;
        }
        System.out.println("key " + string.substring(0, 4));
        return HSCResourceBundleUtil.getMessage("CecNoConnSrcBundle", string.substring(0, 4), null) + " " + string;
    }

    public static boolean isStorageDevice(UnsignedInt16 unsignedInt16) {
        if (unsignedInt16 == null) {
            return false;
        }
        int n = unsignedInt16.intValue();
        System.out.println("classCode = " + n);
        System.out.println("PIHscConstants.SCSI_DEV_RANGE0 = 256");
        System.out.println("PIHscConstants.SCSI_DEV_RANGE1 = 511");
        if (n >= 256 && n <= 511) {
            int n2 = n & 0xFF;
            if (n2 == 1) {
                return false;
            }
            return n2 != 2;
        }
        return unsignedInt16.equals((Object)new UnsignedInt16(3076));
    }

    public static boolean underIOPAndStorageDev(PIIOSlotDataBean pIIOSlotDataBean) {
        if (pIIOSlotDataBean == null) {
            return false;
        }
        UnsignedInt32 unsignedInt32 = null;
        try {
            unsignedInt32 = new UnsignedInt32(Long.parseLong(pIIOSlotDataBean.getParentDrcIndex()));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        UnsignedInt16 unsignedInt16 = null;
        try {
            unsignedInt16 = pIIOSlotDataBean.getPciClass();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return PIHscUtil.isStorageDevice(unsignedInt16) && unsignedInt32 != null && !unsignedInt32.equals((Object)new UnsignedInt32(0L)) && !unsignedInt32.equals((Object)new UnsignedInt32(-1L));
    }
}

